/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.client.screen.legacy.buyer;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.TextBox;
import dev.ftb.mods.ftblibrary.ui.TextField;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.sixik.sdm_economy.api.CurrencyHelper;
import net.sixik.sdmshoprework.SDMShopClient;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.client.screen.basic.buyer.AbstractBuyerBuyButton;
import net.sixik.sdmshoprework.client.screen.basic.buyer.AbstractBuyerCancelButton;
import net.sixik.sdmshoprework.client.screen.basic.buyer.AbstractBuyerScreen;
import org.jetbrains.annotations.Nullable;

public class LegacyBuyerScreen
extends AbstractBuyerScreen {
    public TextBox inputField;
    public TextField infoField;
    public TextField infoProductField;
    public TextField costBuyField;
    public TextField outputMoneyField;
    public int cantBuy = 0;

    public LegacyBuyerScreen(AbstractShopEntry entry) {
        this.shopEntry = entry;
        int bsize = this.width / 2 - 10;
        final int howMane = entry.getEntryType().howMany((Player)Minecraft.m_91087_().f_91074_, entry.isSell, entry);
        this.inputField = new TextBox((Panel)this){

            public boolean isValid(String txt) {
                return LegacyBuyerScreen.this.parse(null, txt, 0, howMane);
            }

            public void onTextChanged() {
                if (this.isValid(this.getText()) && !this.getText().isEmpty()) {
                    String f1 = this.getText();
                    if (f1.startsWith("0") && f1.length() > 1) {
                        StringBuilder d1 = new StringBuilder();
                        for (int i = 1; i < f1.length(); ++i) {
                            d1.append(f1.charAt(i));
                        }
                        LegacyBuyerScreen.this.updateCountInfo(Integer.parseInt(d1.toString()));
                        return;
                    }
                    LegacyBuyerScreen.this.updateCountInfo(Integer.parseInt(this.getText()));
                }
            }
        };
        this.inputField.setPosAndSize(8, 8, this.width - 16, 16);
        this.inputField.setText("0");
        this.inputField.setCursorPosition(this.inputField.getText().length());
        this.inputField.setFocused(true);
        this.infoField = new TextField((Panel)this);
        this.infoField.setPos(8, this.inputField.posY + this.inputField.height + 2);
        this.infoField.setSize(this.inputField.width, 9);
        this.infoField.setText((Component)Component.m_237110_((String)"sdm.shop.buyer.info.count.money", (Object[])new Object[]{CurrencyHelper.Basic.getMoney((Player)Minecraft.m_91087_().f_91074_)}));
        this.infoProductField = new TextField((Panel)this);
        this.infoProductField.setPos(8, this.infoField.posY + this.infoField.height + 2);
        this.infoProductField.setSize(this.inputField.width, 9);
        this.infoProductField.setText((Component)(entry.isSell ? Component.m_237110_((String)"sdm.shop.buyer.info.entry.sell", (Object[])new Object[]{howMane}) : Component.m_237110_((String)"sdm.shop.buyer.info.entry.buy", (Object[])new Object[]{howMane})));
        this.costBuyField = new TextField((Panel)this);
        this.costBuyField.setPos(8, this.infoProductField.posY + this.infoProductField.height + 10);
        this.costBuyField.setSize(this.inputField.width, 9);
        this.costBuyField.setText((Component)(entry.isSell ? Component.m_237110_((String)"sdm.shop.buyer.info.cost.sell", (Object[])new Object[]{0}) : Component.m_237110_((String)"sdm.shop.buyer.info.cost.buy", (Object[])new Object[]{0})));
        this.outputMoneyField = new TextField((Panel)this);
        this.outputMoneyField.setPos(8, this.costBuyField.posY + this.costBuyField.height + 2);
        this.outputMoneyField.setSize(this.inputField.width, 9);
        this.outputMoneyField.setText((Component)Component.m_237110_((String)"sdm.shop.buyer.info.money.left", (Object[])new Object[]{CurrencyHelper.Basic.getMoney((Player)Minecraft.m_91087_().f_91074_)}));
        this.cancelButton = new CancelButton((Panel)this);
        this.cancelButton.setPosAndSize(8, this.height - 24, bsize, 16);
        this.buyButton = new BuyButton((Panel)this);
        this.buyButton.setPosAndSize(this.width - bsize - 8, this.height - 24, bsize, 16);
    }

    public boolean parse(@Nullable Consumer<Integer> callback, String string, int min, int max) {
        try {
            int v = Long.decode(string).intValue();
            if (v >= Integer.valueOf(min) && v <= Integer.valueOf(max)) {
                if (callback != null) {
                    callback.accept(v);
                }
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public void updateCountInfo(int count) {
        if (this.costBuyField == null) {
            return;
        }
        long d1 = (long)count * this.shopEntry.entryPrice;
        this.count = count;
        this.costBuyField.setText((Component)Component.m_237110_((String)"sdm.shop.buyer.info.cost.buy", (Object[])new Object[]{d1}));
        int money = this.shopEntry.isSell ? (int)(CurrencyHelper.Basic.getMoney((Player)Minecraft.m_91087_().f_91074_) + d1) : (int)(CurrencyHelper.Basic.getMoney((Player)Minecraft.m_91087_().f_91074_) - d1);
        this.outputMoneyField.setText((Component)Component.m_237110_((String)"sdm.shop.buyer.info.money.left", (Object[])new Object[]{money}));
        this.refreshWidgets();
    }

    public boolean onInit() {
        this.closeContextMenu();
        return true;
    }

    public void addWidgets() {
        this.add((Widget)this.buyButton);
        this.add((Widget)this.cancelButton);
        this.add((Widget)this.infoField);
        this.add((Widget)this.infoProductField);
        this.add((Widget)this.costBuyField);
        this.add((Widget)this.outputMoneyField);
        this.add((Widget)this.inputField);
    }

    public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
        SDMShopClient.getTheme().draw(graphics, x, y, w, h);
    }

    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            if (key.is(69) || key.is(259)) {
                return false;
            }
            if (key.esc()) {
                this.cancelButton.onClicked(MouseButton.LEFT);
            }
            return true;
        }
        return false;
    }

    protected static class CancelButton
    extends AbstractBuyerCancelButton {
        public CancelButton(Panel panel) {
            super(panel);
        }

        public boolean renderTitleInCenter() {
            return true;
        }

        public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
            SDMShopClient.getTheme().draw(graphics, x, y, w, h);
        }
    }

    protected static class BuyButton
    extends AbstractBuyerBuyButton {
        public BuyButton(Panel panel) {
            super(panel);
        }

        public boolean renderTitleInCenter() {
            return true;
        }

        public void drawBackground(PoseStack graphics, Theme theme, int x, int y, int w, int h) {
            SDMShopClient.getTheme().draw(graphics, x, y, w, h);
        }
    }
}

